#include "mex.h"
#include "matrix.h"
#include "math.h"
#include "stdio.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )

{

    /* -- Inputs -- */
	double *nin		= mxGetPr(prhs[0]);
	double *nein	= mxGetPr(prhs[1]);
    double *xss 	= mxGetPr(prhs[2]);
    double *yss 	= mxGetPr(prhs[3]);
	double *parmin 	= mxGetPr(prhs[4]);
	double *nnuin 	= mxGetPr(prhs[5]);
	double *Gsp 	= mxGetPr(prhs[6]);

	/* -- Specific Inputs -- */
	int n 				= nin[0];
	int ne 				= nein[0];
	double nnus 		= nnuin[0];
	double bbeta 		= parmin[0];
	double rrho 		= parmin[1];
	double oomega 		= parmin[2];
	double eeta 		= parmin[3];
	double aalpha 		= parmin[4];
	double ddelta 		= parmin[5];
	double pbar 		= parmin[6];
	double ebar 		= parmin[7];
	double iiota 		= parmin[8];
	double pphi 		= parmin[9];
	double rbar 		= parmin[10];
	double kkappa   	= parmin[11];
	double rrhoa 		= parmin[12];
	double rrhoz 		= parmin[13];
	double rrhop 		= parmin[14];
	double rrhor 		= parmin[15];
	double rrhoe 		= parmin[16];
	double rrhod 	 	= parmin[17];
	double varphibar 	= parmin[18];
	double bbar 		= parmin[19];
	double ppsir 		= parmin[20];
	double abar  		= parmin[21];
	double zbar 		= parmin[22];
	double ssigmaa		= parmin[23];
	double ssigmaz 		= parmin[24];
	double ssigmap		= parmin[25];
	double ssigmar		= parmin[26];
	double ssigmae		= parmin[27];
	double ssigmad		= parmin[28];



	/* -- Outputs -- */
	plhs[0] = mxCreateDoubleMatrix(n,n,mxREAL);
	plhs[1] = mxCreateDoubleMatrix(n,ne,mxREAL);
	double *Ce_sp_s = mxGetPr(plhs[0]);
	double *De_sp_s = mxGetPr(plhs[1]);

    /* -- Definition of Variables -- */
    double E = 2.71828182845905;


	/* -- Mathematica Output Here -- */
	Ce_sp_s[168]=pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho);
	Ce_sp_s[192]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho);
	Ce_sp_s[216]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho;
	Ce_sp_s[384]=-pow(E,yss[8]);
	Ce_sp_s[49]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Ce_sp_s[73]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Ce_sp_s[97]=-(pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Ce_sp_s[217]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Ce_sp_s[241]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha);
	Ce_sp_s[313]=-((pbar*pphi*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Ce_sp_s[385]=(pbar*pphi*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Ce_sp_s[409]=-((pbar*pphi*(1 + yss[5]))/pow(E,yss[8]));
	Ce_sp_s[50]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha);
	Ce_sp_s[74]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha);
	Ce_sp_s[218]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha);
	Ce_sp_s[242]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha);
	Ce_sp_s[314]=-(pow(E,yss[7] - yss[8])*pphi*(pow(E,yss[8]) + yss[9]));
	Ce_sp_s[362]=-(pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Ce_sp_s[386]=pow(E,yss[7] - yss[8])*pphi*(1 + yss[5])*yss[9];
	Ce_sp_s[410]=-(pow(E,yss[7] - yss[8])*pphi*(1 + yss[5]));
	Ce_sp_s[3]=(bbeta*pow(E,yss[8])*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Ce_sp_s[27]=(bbeta*pow(E,yss[8])*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Ce_sp_s[51]=(bbeta*pow(E,yss[8])*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Ce_sp_s[75]=-((bbeta*pow(E,yss[8])*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Ce_sp_s[99]=(bbeta*pow(E,yss[8])*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Ce_sp_s[123]=(bbeta*pow(E,yss[8])*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Ce_sp_s[147]=(bbeta*pow(E,yss[8])*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Ce_sp_s[171]=(bbeta*pow(E,yss[8])*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Ce_sp_s[315]=(bbeta*pow(E,yss[8]))/pow(zbar,rrho);
	Ce_sp_s[387]=-pow(E,yss[8]);
	Ce_sp_s[411]=1;
	Ce_sp_s[4]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Ce_sp_s[28]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Ce_sp_s[52]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Ce_sp_s[76]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Ce_sp_s[100]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Ce_sp_s[124]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Ce_sp_s[148]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Ce_sp_s[172]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Ce_sp_s[340]=-(kkappa*yss[9]);
	Ce_sp_s[388]=pow(E,yss[8]);
	Ce_sp_s[412]=-kkappa;
	Ce_sp_s[5]=iiota*zbar;
	Ce_sp_s[77]=iiota*zbar;
	Ce_sp_s[341]=-1;
	Ce_sp_s[222]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega);
	Ce_sp_s[366]=-pow(E,yss[7]);
	Ce_sp_s[31]=-(zbar/(1 + yss[5]));
	Ce_sp_s[55]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha);
	Ce_sp_s[79]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]);
	Ce_sp_s[103]=-(pow(E,yss[2])*pbar*(1 + pphi*yss[5]));
	Ce_sp_s[151]=-(pow(E,yss[11])*ebar);
	Ce_sp_s[199]=-pow(E,yss[0]);
	Ce_sp_s[223]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5];
	Ce_sp_s[247]=pow(E,yss[2])*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Ce_sp_s[271]=-pow(E,yss[3]);
	Ce_sp_s[319]=-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2);
	Ce_sp_s[367]=-(pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Ce_sp_s[8]=-(pow(E,xss[0])*zbar);
	Ce_sp_s[80]=-(pow(E,xss[0])*zbar);
	Ce_sp_s[272]=pow(E,yss[3]);
	Ce_sp_s[9]=pow(E,xss[0])*kkappa*zbar;
	Ce_sp_s[33]=zbar/(1 + yss[5]);
	Ce_sp_s[81]=pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]);
	Ce_sp_s[105]=-(pow(E,yss[2])*pbar*pphi*(1 + yss[5]));
	Ce_sp_s[225]=-(pow(E,yss[1] + yss[7])*pphi*(1 + yss[5]));
	Ce_sp_s[249]=-(pow(E,yss[2])*pbar*pphi*(1 + yss[5]));
	Ce_sp_s[321]=-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2);
	Ce_sp_s[345]=pow(E,xss[0])*kkappa*zbar;
	Ce_sp_s[369]=-(pow(E,yss[1] + yss[7])*pphi*(1 + yss[5]));
	Ce_sp_s[441]=-1;
	Ce_sp_s[418]=-1 + nnus;
	Ce_sp_s[442]=nnus;
	Ce_sp_s[35]=-(pow(E,bbar - xss[1])*ppsir);
	Ce_sp_s[131]=1;
	Ce_sp_s[323]=-1;
	Ce_sp_s[12]=pow(E,xss[0]);
	Ce_sp_s[300]=-pow(E,xss[0]);
	Ce_sp_s[61]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha));
	Ce_sp_s[85]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha));
	Ce_sp_s[109]=pow(E,yss[2])*pbar;
	Ce_sp_s[229]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha));
	Ce_sp_s[253]=pow(E,yss[2])*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Ce_sp_s[469]=pow(E,yss[11]);
	Ce_sp_s[38]=-(zbar/pow(E,yss[11]));
	Ce_sp_s[86]=-((zbar*xss[1])/pow(E,yss[11]));
	Ce_sp_s[470]=(zbar*xss[1])/pow(E,yss[11]);
	Ce_sp_s[494]=1;
	Ce_sp_s[39]=-(zbar/pow(E,yss[11]));
	Ce_sp_s[87]=-((zbar*xss[1])/pow(E,yss[11]));
	Ce_sp_s[471]=((-1 + zbar)*xss[1])/pow(E,yss[11]);
	Ce_sp_s[519]=1;
	Ce_sp_s[160]=ebar;
	Ce_sp_s[208]=pow(E,yss[0] - yss[11]);
	Ce_sp_s[280]=pow(E,yss[3] - yss[11]);
	Ce_sp_s[472]=-((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)/pow(E,yss[11]));
	Ce_sp_s[544]=1;
	Ce_sp_s[17]=(pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Ce_sp_s[41]=(pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Ce_sp_s[65]=(pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Ce_sp_s[89]=-((pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Ce_sp_s[113]=(pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Ce_sp_s[137]=(pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Ce_sp_s[161]=(pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Ce_sp_s[185]=(pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Ce_sp_s[425]=-(pow(zbar,rrho)/(bbeta*pow(E,yss[8])));
	Ce_sp_s[569]=1;
	Ce_sp_s[66]=-1;
	Ce_sp_s[91]=-1;
	Ce_sp_s[116]=-1;
	Ce_sp_s[189]=-1;
	Ce_sp_s[166]=-1;
	Ce_sp_s[143]=-1;
	De_sp_s[18]=ssigmaa;
	De_sp_s[43]=ssigmaz;
	De_sp_s[68]=ssigmap;
	De_sp_s[141]=ssigmad;
	De_sp_s[118]=ssigmae;
	De_sp_s[95]=ssigmar;

}
